from __future__ import absolute_import, print_function, unicode_literals
import Live
from .playback_controller import ShowFlow  # Assuming playback_controller.py contains the ShowFlow class
from ableton.v2.control_surface.capabilities import CONTROLLER_ID_KEY, NOTES_CC, PORTS_KEY, REMOTE, SCRIPT, controller_id, inport, outport



def get_capabilities():
    return {CONTROLLER_ID_KEY: controller_id(vendor_id=0000,
                          product_ids=[
                         0000],
                          model_name=[
                         'ShowFlow Show Control']),
     
     PORTS_KEY: [
                 inport(props=[SCRIPT, REMOTE, NOTES_CC]),
                 outport(props=[SCRIPT, REMOTE, NOTES_CC])]}


def create_instance(c_instance):
    """This is the entry point that Ableton Live calls when loading the control surface."""
    return ShowFlow(c_instance=c_instance)
